﻿using System;
using System.Web;

using VIRP.CRS.BLL;
using VIRP.CRS.BO;
using VIRP_WEB.BaseCode;

namespace VIRP_WEB.Custom.EFR
{
    public partial class Patient : EfrBasePage
    {
        private int patientId;

        protected override void Page_Load(object sender, EventArgs e)
        {
            ObjectDataPatient.SelectParameters["CURRENT_USER"].DefaultValue = HttpContext.Current.User.Identity.Name;
            ObjectDataPatient.SelectParameters["CURRENT_REGISTRY_ID"].DefaultValue = UserSession.CurrentRegistryId.ToString();

            if (!IsPostBack)
            {
                if (int.TryParse(Request.QueryString["patientId"], out patientId))
                    SetupDemographics(patientId);

                SetReferringPage();

                ReplacePageTitle("Patients > Patient Lookup > Patient Information > " + ((System.Web.UI.WebControls.Label)(FormViewPatient.FindControl("FullNameLabel"))).Text);
            }
        }

        protected string GetFullName(object lastName, object firstName, object middleName)
        {
            return lastName + ", " + firstName + " " + middleName;
        }

        private void SetupDemographics(int patientId)
        {
            var demo = REGISTRY_DEMOGRAPHICSManager.GetItemByPatientId(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, patientId);

            if (demo != null)
            {
                txtStreetAddress1.Text = demo.ADDRESS_LINE1;
                txtStreetAddress2.Text = demo.ADDRESS_LINE2;
                txtStreetAddress3.Text = demo.ADDRESS_LINE3;
                txtAddressCity.Text = demo.CITY;
                txtAddressState.Text = demo.STATE;
                txtAddressZip.Text = demo.POSTAL_CODE;
                txtAddressCountry.Text = demo.COUNTRY;

                txtHomePhone.Text = demo.HOME_PHONE;
                txtWorkPhone.Text = demo.WORK_PHONE;
                txtMobilePhone.Text = demo.CELL_PHONE;

                txtEmailAddress.Text = demo.EMAIL_ADDRESS;

                if (demo.PREFERRED_PHONE_TYPE == "Home")
                    RadioButtonListPreferredAlternateTelephoneNumber.SelectedIndex = 0;
                else if (demo.PREFERRED_PHONE_TYPE == "Work")
                    RadioButtonListPreferredAlternateTelephoneNumber.SelectedIndex = 1;
                else if (demo.PREFERRED_PHONE_TYPE == "Mobile")
                    RadioButtonListPreferredAlternateTelephoneNumber.SelectedIndex = 2;
            }
        }

        protected void SaveButton_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                string strResult = string.Empty;

                if (int.TryParse(Request.QueryString["patientId"], out patientId))
                {
                    SaveCompletePatientDemographics();

                    SetupDemographics(patientId);

                    SetSaveSuccessMessage();
                }
                else
                    SetSaveMessage("Invalid Patient.");
            }
            catch (Exception ex)
            {
                SetSaveMessage("Error encountered saving information.");

                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        private int SaveCompletePatientDemographics()
        {
            var demo = REGISTRY_DEMOGRAPHICSManager.GetItemByPatientId(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, patientId);

            if (demo != null)
                return SaveDemographics(ref demo);

            demo = new REGISTRY_DEMOGRAPHICS { PATIENT_ID = patientId };

            return SaveDemographics(ref demo);
        }

        private int SaveDemographics(ref REGISTRY_DEMOGRAPHICS rdemo)
        {
            rdemo.ADDRESS_LINE1 = txtStreetAddress1.Text.Trim();
            rdemo.ADDRESS_LINE2 = txtStreetAddress2.Text.Trim();
            rdemo.ADDRESS_LINE3 = txtStreetAddress3.Text.Trim();
            rdemo.CITY = txtAddressCity.Text.Trim();
            rdemo.STATE = txtAddressState.Text.Trim();
            rdemo.POSTAL_CODE = txtAddressZip.Text.Trim();
            rdemo.COUNTRY = txtAddressCountry.Text;

            rdemo.HOME_PHONE = txtHomePhone.Text;
            rdemo.WORK_PHONE = txtWorkPhone.Text;
            rdemo.CELL_PHONE = txtMobilePhone.Text;

            if (RadioButtonListPreferredAlternateTelephoneNumber.SelectedIndex == 0)
                rdemo.PREFERRED_PHONE_TYPE = "Home";
            else if (RadioButtonListPreferredAlternateTelephoneNumber.SelectedIndex == 1)
                rdemo.PREFERRED_PHONE_TYPE = "Work";
            else
                rdemo.PREFERRED_PHONE_TYPE = "Mobile";

            rdemo.EMAIL_ADDRESS = txtEmailAddress.Text;

            rdemo.STD_REGISTRY_ID = UserSession.CurrentRegistryId;

            // alt address 
            rdemo.STD_ADDRESSTYPE_ID = 1;

            return REGISTRY_DEMOGRAPHICSManager.Save(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, rdemo);
        }

        protected void CancelButton_OnClick(object sender, EventArgs e)
        {
            RedirectToReferringPage();
        }

        protected void LinkButtonWorkflows_Click(object sender, EventArgs e)
        {
            if (int.TryParse(Request.QueryString["patientId"], out patientId))
                Response.Redirect(string.Format("~/Custom/EFR/Patients/PatientWorkflows.aspx?PatientId={0}", patientId), false);
        }

        protected void LinkButtonRelatedDiagnoses_Click(object sender, EventArgs e)
        {
            if (int.TryParse(Request.QueryString["patientId"], out patientId))
                Response.Redirect(string.Format("~/Custom/EFR/Patients/PatientRelatedDiagnoses.aspx?PatientId={0}", patientId), false);
        }

        protected void LinkButtonLabTests_Click(object sender, EventArgs e)
        {
            if (int.TryParse(Request.QueryString["patientId"], out patientId))
                Response.Redirect(string.Format("~/Custom/EFR/Patients/PatientRelatedLabTests.aspx?PatientId={0}", patientId), false);
        }

        protected void LinkButtonImages_Click(object sender, EventArgs e)
        {
            if (int.TryParse(Request.QueryString["patientId"], out patientId))
                Response.Redirect(string.Format("~/Custom/EFR/Patients/PatientImaging.aspx?PatientId={0}", patientId), false);
        }
    }
}